//*********************************************************************************
// W PLAYER API CODE - SETUP
//*********************************************************************************

//Listen in on incoming data 
$wp.setDefaultCallback((object) => {
    switch (object.type) {
        case 'state':
		
            //Call function to perform actions based on CURRENT STATE
			setCallbackByPlayState(object.sub, object.data);
			
            break;
        case 'udp':            
			
            break;
        case 'datalink':
            
            break;
        default:
            break;
    }
});


function setCallbackByPlayState(state, data) {
    switch (state) {
        case 'ready':
		
			//In order to receive a keydown event from a remote controller or keyboard, we need to place focus on the foreground window            
            window.focus();	
			    
			//Add an event listener to Video1 on Page1 waiting for a user click 
			$wp.content.getPage("Page1").getElement("Video1").addEventListener("click", showProductInfo);            
		
			break;            
        case 'play':
		
			break;            
        case 'stop':
            
            break;
        default:
            break;
    }
}

//*********************************************************************************
// W PLAYER API CODE - USER FUNCTIONS
//*********************************************************************************

function showProductInfo() {
	
	//Move to Page2 within template with product info
	$wp.content.movePage("Page2");
}


//*********************************************************************************
// JS CODE
//*********************************************************************************

window.onload = function () {
	//Setup anything you want to run immediately after the page has loaded (optional)	
}